﻿// if menu is set overlay = true

$.initAffix = function () {
    $('.navbar').affix({
        offset: {
            top: function () {
                return (this.top = $('.navbar').offset().top);
            }
        }
    });
};

$.resetAffix = function () {
    $(window).off('.affix');
    $('.navbar').removeData('bs.affix').removeClass('affix affix-top affix-bottom');

    $('.navbar').attr('data-spy', 'affix');
    $('.navbar').attr('data-offset-top', $('.navbar').offset().top);
    $.initAffix();
};

$.resizeAffix = function () {
    $(window).on('resize', $.resetAffix);
};

$.resizeWindow = function () {
    $.resetAffix;
    ResizeVideoBanner();
}


$(function () {
    if ($('.navbar').attr('data-spy') == 'affix') {

        $.initAffix();
        $(window).on('resize', $.resizeWindow);

        //$('.navbar').attr('data-offset-top', $('.navbar').offset().top);
        //$(window).resize(function () {
        //    $('.navbar').off('.affix');
        //    $('.navbar').affix({ offset: { top: $('.navbar').offset().top } });
        //});
    }
    else {
        $.resizeAffix();
        if ($(window).width() <= 768) {
            $('.navbar').attr('data-spy', 'affix');
            $('.navbar').attr('data-offset-top', $('.navbar').offset().top);
            $.initAffix();
            //$(window).on('resize', $.resetAffix);
        }
    }



    if ($('.navbar').css('z-index') != '999999') {
        $('.navbar').parent('div').height($('.navbar').outerHeight());
        $(window).resize(function () {
            $('.navbar').parent('div').height($('.navbar').outerHeight());
            $('.navbar').attr('data-offset-top', $('.navbar').offset().top);
        });
    }

    // Active menu
    var currentPage = window.location.href.split('/')[window.location.href.split('/').length - 1];
    $('.navbar-nav a[href="' + currentPage + '"]').css('font-weight', 'bold');

    LoadChildContentVideo();

    // Reload image
    ReloadImage();

    ResizeVideoBanner();

    $.each($('.columnsetting'), function () {
        if ($(this).css('min-height') == '0px') {
            var mTop = $(this).css('margin-top').replace('px', '');
            var mBottom = $(this).css('margin-bottom').replace('px', '');
            var styleMinHeight = (parseInt(mTop) + parseInt(mBottom)) + 'px';
            $(this).css('min-height', 'calc(100% - ' + styleMinHeight + ')')
        }
    });

    AutoPlayVideo();

    // Remove map type Terrain & Hybrid
    ReplaceMapType();

    // Loading custom form
    LoadingCustomForm()

});

function LoadingCustomForm() {
    if ($('.content_formonline').length) {
        //$('.content_formonline').prepend('<div class=formspinner><img src="/images/loading.gif" /> <div>')
        $('.formspinner').css('display', 'none');
        //$('.iframeForm').load(function () {
        //    $('.formspinner').css('display', 'none');
        //});
    }
}

function LoadPhotoGallery(linkCMS, contain) {
    $.ajax({
        url: linkCMS + "iframe/PhotoGalleryAjax.aspx",
        type: "GET",
        dataType: "html",
        success: function (data) {
            $(contain).html(data);
        },
        error: function (err) {
            console.log(err);
        }
    });
}

function ReloadImage() {
    if ($('body').css('background-image') != 'none') {
        $('body').css('background-image', $('body').css('background-image').replace('")', '?v=' + Date.now() + '")'));
    }
    $($('.layoutsetting')).each(function () {
        if ($(this).css('background-image') != 'none') {
            $(this).css('background-image', $(this).css('background-image').replace('")', '?v=' + Date.now() + '")'));
        }
    });
    $($('.columnsetting')).each(function () {
        if ($(this).css('background-image') != 'none') {
            $(this).css('background-image', $(this).css('background-image').replace('")', '?v=' + Date.now() + '")'));
        }
    });

    $($('.columnsetting .content_images div:eq(0)')).each(function () {
        if ($(this).css('background-image') != 'none') {
            $(this).css('background-image', $(this).css('background-image').replace('?v=', '?v=' + Date.now()));
        }
    });
}

function ResizeVideoBanner() {

    $.each($('.fullsize-video-bg'), function () {
        var video = $(this).find('video');
        $(this).css('height', video.attr('data-height') == 'auto' ? video.height() : video.attr('data-height'));

        $(this).find('.video-viewport').width($(this).width());
        $(this).find('.video-viewport').height($(this).height());

        $(this).find('.video-viewport').scrollLeft((video.width() - $(this).width()) / 2);
        $(this).find('.video-viewport').scrollTop((video.height() - $(this).height()) / 2);

        // Register Event Click
        $(this).unbind('click');
        $(this).click(function () {
            if (video[0].paused)
                video[0].play();
            else
                video[0].pause();
        });
    });
};

function LoadChildContentVideo() {
    $.each($('.fullsize-video-bg'), function () {
        var id = $(this).attr('data-id');
        var listContent = $(this).parents('.columnsetting').find('div[contentchild="true"][data-pid="' + id + '"]');
        if (listContent.length > 0) {
            var nodeInner = $(this).children('.inner');
            $.each(listContent, function () {
                $(this).appendTo(nodeInner);
            });
        }
    });
}

function AutoPlayVideo() {
    $.each($('video[autoplay]'), function () {
        this.play();
    });
}

function replaceAll(find, replace, str) {
    if (find === replace) return str;
    while (str.indexOf(find) > -1) {
        str = str.replace(find, replace);
    }
    return str;
}

function ReplaceMapType() {
    if ($('.content_googlemap').length > 0) {
        setTimeout(function () {
            $.each($('.content_googlemap'), function () {
                var iframe = $(this).find('iframe');
                src = iframe.attr('src');
                src = src.replace('hybrid', 'roadmap').replace('Terrain', 'roadmap');
                iframe.attr('src', src + '&');
            });
        }, 500);
    }

}